<?php
class Controller_Frontend extends Controller_Frontend_Base {

	public $template = "frontend/layout";

    public function before()
    {

		$fullURL = URL::site($this->request->uri(), TRUE);
        $shortURL = $this->request->uri();

		$langPart = substr($shortURL , 0 , 2 );

		$languages = Kohana::$config->load('app.languages');

		if ( in_array ( $langPart , $languages ) ) {
			$_GET['lang'] = $langPart;
			Session::instance()->set('redirect_after_language' , $shortURL);
		}

		$lang = arr::get($_GET , 'lang');

		$lng = i18n::lang();

        //var_dump($lang);var_dump(Model_Text::getLanguage());var_dump($lng);die;

		if ( ( strlen ( $lang ) == 2 && ( $lang != Model_Text::getLanguage() || $lng != $lang ) ) ) {
			Session::instance()->set('lang' , $lang );
			I18n::lang(Model_Text::getLanguage());
			Cookie::set('lang' , I18n::lang() , 9999999999);
			$redir = Session::instance()->get_once('redirect_after_language');

			//var_dump($redir);die;

			if ( !empty ( $redir ) && !is_null($lang)) {

				if ( $redir == "hu" || $redir == "en" ||  $redir == "de" || $redir == "/" ) {}
				else {
					Session::instance()->delete('redirect_after_language');
					$this->redirect ( $redir );die;
				}
			}
			$this->redirect('/' . I18n::lang());die;
		}

		View::set_global('fullurl', $fullURL );
        View::set_global('shorturl', $shortURL );
		View::set_global('loggedin' , $this->isLoggedIn());
		View::set_global('lang' , Model_Text::getLanguage() );

		View::set_global('lang_id' , arr::get(Kohana::$config->load('app.languages_reverse') , Model_Text::getLanguage() ));
		I18n::lang(Model_Text::getLanguage());
		Cookie::set('lang' , I18n::lang());


		//echo Debug::vars($this);


		parent::before();

		$this->response->headers('X-Programmed-By' , 'https://pointfive.hu');
		

		

	}

    public function action_index() {
		$lang = $this->request->param('lang');

		$currlng = Session::instance()->get('lang' , 'hu');

		if ( empty ( $lang ) ) { $this->redirect('/' . $currlng , 301 );die; }
		

		$this->template->currentpage = "index";
		
		$text = ORM::Factory('Text_Translation' , 1 )->as_array();

        $this->template->meta = Meta::prepare('static' , $text  );
		$this->template->title =  arr::get($text, 'meta_title') . " - biggeorge.hu";
        
        $this->template->content = View::Factory('frontend/index' , $this->params );
    }


	public function action_static() {
		$lang = $this->request->param('lang');
		$menu = $this->request->param('menu');
		$page = $this->request->param('url');
		$sentstr = "";
		
		if ( $page == "friss-arfolyamok" ) {
			$this->redirect('/hu/friss-arfolyamok/friss-arfolyamok-elore-definialt-idoszakokra');
		}
		
		$captcha = captcha::instance();
		$this->setData('captcha' , $captcha);

		//var_dump($this->request);die;
       
		Session::instance()->set('lang' , $lang );

		$text = Model_Text::getText ( $lang , $page );

		//var_dump($text);die;
		
		$parent = arr::get($text,'parent');
		//var_dump($text);die;
		$c = ORM::Factory('Category' , $parent );
		if ( $c->parentid == 1 || $c->parentid == 3 ) {

			$cat = ORM::Factory('Category')
				->where_open()
					->where('slug_hu' , '=' , $page)
					->or_where('slug_en' , '=' , $page)
				->where_close()
				->where('deleted' , '=' , 0 )
			->find();
				
			//var_dump($cat->as_array());die;
			if ( $cat->loaded() ) {
				$firstChild = ORM::Factory('Category')->where('deleted' , '=' , 0 )->where('parentid' , '=' , $cat->id)->order_by('o' , 'asc')->find();
				//var_dump($firstChild->as_array());die;
				if ( $firstChild->loaded() ) { 
					//var_dump($firstChild->as_array());die;
					$path = $lang . '/' . $cat->slug_hu . '/' . $firstChild->slug_hu;
					//var_dump($path);die;
					$this->redirect($path);
				}
			}
		}

		$sent = 0;
        $errors = array();
        $post = $_POST;
        $form = "";


		$tid = arr::get($text,'text_id');
		if ( $tid == 13 ) {
			$this->response->status( 404 );
		}

		$post = Validation::factory($_POST);
		$post
			->labels(array(
				'nev' => __('Név'),
				'telefon' => __('Telefon'),
				'email' => __('E-mail'),
				'milyen' => __('Milyen befektetést tervez'),
				'mekkora' => __('Mekkora befektetést tervez'),
				'adatkezeles' => __('Adatkezelés'),
				
			 ))
			->rule('nev' , 'not_empty')
			->rule('email' , 'not_empty')
			->rule('email', 'not_empty')
			->rule('email', 'email')
			->rule('telefon' , 'not_empty')
			->rule('milyen' , 'not_empty')
			->rule('mekkora' , 'not_empty')
			->rule('adatkezeles' , 'not_empty')
		;

		if ( !empty ( $_POST ) ) {
			if ( $post->check() ) {
				//echo 'megy';
				
				$str =  "Név: " . arr::get($_POST , 'nev') . "\n";
				$str .= "E-mail: " . arr::get($_POST , 'email') . "\n";
				$str .= "Telefon: " . arr::get($_POST , 'telefon') . "\n";
				$str .= "Milyen befektetés: " . arr::get($_POST , 'milyen') . "\n";
				$str .= "Mekkora befektetés: " . arr::get($_POST , 'mekkora') . "\n";
				$str .= "Hírlevél: " . arr::get($_POST , 'hirlevel') . "\n";
				
				
				$to      = 'info@bgalapkezelo.hu';
				$subject = 'Ajánlatkérés';
				$message = $str;
				$headers = 'From: ' . arr::get($_POST , 'email') . "\r\n" .
				    'X-Mailer: PHP/' . phpversion();

				mail($to, $subject, $message, $headers);
				mail('sandortibireg@gmail.com', $subject, $message, $headers);
				
				//echo $str;die;
				
				
				$this->redirect('/hu/ajanlatkeres-koszonjuk');
				die;
			} else {
				$text['post']['errors'] = $post->errors('user');
				$text['post']['data'] = $_POST;
			}
		}


		
		
		
		

		$this->setData('data' , $text );
		$this->setData('form' , $form );
		$this->setData('page' , $page );



		$def = array(
			'keywords' => arr::get($text, 'keywords'),
			'description' => arr::get($text, 'description'),
		);

		$this->template->meta = Meta::prepare('static' , $text , $def );
		
		$this->setData('alap' , $menu );
		$this->setData('alap2' , $this->request->param('url') );
		$this->template->title =  arr::get($text, 'meta_title') . " - biggeorge.hu";

		$this->template->content = View::Factory('frontend/static' , $this->params );

	}
	
	
	public function action_search() {
		
		$this->setData('q' , arr::get($_REQUEST , 'q'));
		$this->template->title =  "Keresés - biggeorge.hu";
		$this->template->content = View::Factory('frontend/search' , $this->params );

	}

	
	public function recaptcha($val) {
	    //echo Debug::vars($val);die;
	    
	     $url = "https://www.google.com/recaptcha/api/siteverify?secret=6LccjgUTAAAAALLPDzx-KrCM78t2xKLaFN_Jyc9z".
               "&response=".$val;
 
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE); 
        $curlData = curl_exec($curl);
 
        curl_close($curl);
 
        $res = json_decode($curlData, TRUE);
        if($res['success'] == 'true') 
            return TRUE;
        else
            return FALSE;
            
	}
	
	public function action_json() {
	    $this->auto_render = false;
	    $id = $this->request->param('id');
	    $tol = arr::get($_REQUEST , 'tol');
        $ig = arr::get($_REQUEST , 'ig');
        
	    header('Content-type: application/json');
	    
	    $data = array();
		$data2 = array();

	    $stock = ORM::Factory('Stock');
	    if ( !empty ( $tol ) ) {
	        $stock = $stock->where('datum' , '>=' , $tol );
	    }

	    if ( !empty ( $ig ) ) {
	        $stock = $stock->where('datum' , '<=' , $ig );
	    }
	    
	    $stock = $stock->where('type' , '=' , $id);

	    
	    $stock = $stock->find_all();

	    foreach ( $stock as $s ) {
	        $datum = $s->datum;
	        $data[] = array(
	            strtotime($datum)*1000,
	            floatval(number_format(floatval($s->egyjegy), 2))
	        );
	    }

		foreach ( $stock as $s ) {
	        $datum = $s->datum;
	        $data2[] = array(
	            strtotime($datum)*1000,
	            floatval(number_format(floatval($s->korrigalt), 2))
	        );
	    }
	    
	    $data = json_encode(array('data' => $data, 'data2' => $data2 ) );
	    echo self::prettyPrint($data);
	    die;
	}
	
	public static function prettyPrint( $json )
{
    $result = '';
    $level = 0;
    $in_quotes = false;
    $in_escape = false;
    $ends_line_level = NULL;
    $json_length = strlen( $json );

    for( $i = 0; $i < $json_length; $i++ ) {
        $char = $json[$i];
        $new_line_level = NULL;
        $post = "";
        if( $ends_line_level !== NULL ) {
            $new_line_level = $ends_line_level;
            $ends_line_level = NULL;
        }
        if ( $in_escape ) {
            $in_escape = false;
        } else if( $char === '"' ) {
            $in_quotes = !$in_quotes;
        } else if( ! $in_quotes ) {
            switch( $char ) {
                case '}': case ']':
                    $level--;
                    $ends_line_level = NULL;
                    $new_line_level = $level;
                    break;

                case '{': case '[':
                    $level++;
                case ',':
                    $ends_line_level = $level;
                    break;

                case ':':
                    $post = " ";
                    break;

                case " ": case "\t": case "\n": case "\r":
                    $char = "";
                    $ends_line_level = $new_line_level;
                    $new_line_level = NULL;
                    break;
            }
        } else if ( $char === '\\' ) {
            $in_escape = true;
        }
        if( $new_line_level !== NULL ) {
            $result .= "\n".str_repeat( "\t", $new_line_level );
        }
        $result .= $char.$post;
    }

    return $result;
}

}