<?php
$evek = range(2007, date('Y'));
$evek = array_combine($evek, $evek);

$napok = range(1,31);
$napok = array_combine($napok, $napok);

foreach ( $napok as $k => $v ) {
    if ( $k < 10 ) {
        unset ( $napok[$k]);
        $k = "0" . $k;
        $napok[$k] = $v;
    }
}

ksort($napok);


$honapok = array(
    '01' => __('január'),
    '02' => __('február'),
    '03' => __('március'),
    '04' => __('április'),
    '05' => __('május'),
    '06' => __('június'),
    '07' => __('július'),
    '08' => __('augusztus'),
    '09' => __('szeptember'),
    '10' => __('október'),
    '11' => __('november'),
    '12' => __('december'),
);

$lang = Model_Text::getLanguage();

/*
if ( $lang == "hu")  $tipus = ORM::Factory('Category')->where('deleted' , '=' , 0 )->where('parentid' , '=' , 28 )->order_by('o' , 'asc')->find_all()->as_array('id' , 'hu');
if ( $lang == "en")  $tipus = ORM::Factory('Category')->where('deleted' , '=' , 0 )->where('parentid' , '=' , 28 )->order_by('o' , 'asc')->find_all()->as_array('id' , 'en');
*/

if ( $lang == "hu")  $tipus = ORM::Factory('Category')->where('deleted' , '=' , 0 )->where('parentid' , '=' , 28 )->where('id' , 'not in' , array(65,83,73,95,89,113,125) )->find_all()->as_array('id' , 'hu');

if ( $lang == "en") $tipus = ORM::Factory('Category')->where('deleted' , '=' , 0 )->where('parentid' , '=' , 28 )->where('id' , 'not in' , array(65,83,73,95,89,113,125) )->find_all()->as_array('id' , 'en');

$max = ORM::Factory('Stock')->order_by('datum' , 'desc')->find(); 
?>

<div class="box">
   <form action="" method="get" class="remove-bottom">
   		
   		
   		<div class="row gutters remove-bottom">
            <div class="col span_6"><h4><?php echo __('Alap'); ?></h4></div><!-- // span_6 -->
            <div class="col span_18">
                <?php echo Form::select('tipus' , $tipus , arr::get($_REQUEST , 'tipus'),  array('id'=> 'tipus') ); ?>
            </div><!-- // span_18 -->           
        </div><!-- // row -->
        
        
        <div class="row gutters remove-bottom">
            <div class="col span_6"><h4><?php echo __('Kezdő nap'); ?></h4></div><!-- // span_6 -->
            <div class="col span_6">
                <?php echo Form::select('tol_ev' , $evek , arr::get($_REQUEST , 'tol_ev'), array('id'=> 'tol_ev') ); ?>
            </div><!-- // span_6 -->
            <div class="col span_6">
                <?php echo Form::select('tol_ho' , $honapok , arr::get($_REQUEST , 'tol_ho'), array('id'=> 'tol_ho') ); ?>
            </div><!-- // span_6 -->
            <div class="col span_6">
                <?php echo Form::select('tol_nap' , $napok , arr::get($_REQUEST , 'tol_nap'), array('id'=> 'tol_nap') ); ?>
            </div><!-- // span_6 -->
        </div><!-- // row -->
        <div class="row gutters remove-bottom">
            <div class="col span_6"><h4><?php echo __('Záró nap'); ?></h4></div><!-- // span_6 -->
            <div class="col span_6">
                <?php echo Form::select('ig_ev' , $evek , arr::get($_REQUEST , 'ig_ev' , date('Y' , strtotime($max->datum))), array('id'=> 'ig_ev')); ?>
            </div><!-- // span_6 -->
            <div class="col span_6">
                <?php echo Form::select('ig_ho' , $honapok , arr::get($_REQUEST , 'ig_ho', date('m' , strtotime($max->datum))), array('id'=> 'ig_ho')); ?>
            </div><!-- // span_6 -->
            <div class="col span_6">
                <?php echo Form::select('ig_nap' , $napok , arr::get($_REQUEST , 'ig_nap', date('d' , strtotime($max->datum))), array('id'=> 'ig_nap')); ?>

            </div><!-- // span_6 -->
        </div><!-- // row -->
        <div class="row gutters text-center remove-bottom">
            <div class="col span_24">
                <input type="submit" value="<?php echo __('Hozamszámítás'); ?>" class="active remove-bottom">
            </div><!-- // span_24 -->
        </div><!-- // row -->
   </form>
</div>


<script type="text/javascript">
$(function () {
	
	$('#tipus').on('change', function() {
	  if( $(this).val() == "48" ){
			$("#tol_ev").val("2007");
			$("#tol_ho").val("01");
			$("#tol_nap").val("01");
	  }else if( $(this).val() == "65" ){
			$("#tol_ev").val("2016");
			$("#tol_ho").val("10");
			$("#tol_nap").val("10");
	  }
	});
	
});
</script>

<?php
$tol_ev = arr::get($_REQUEST , 'tol_ev');
$tol_ho = arr::get($_REQUEST , 'tol_ho');
$tol_nap = arr::get($_REQUEST , 'tol_nap');

$ig_ev = arr::get($_REQUEST , 'ig_ev');
$ig_ho = arr::get($_REQUEST , 'ig_ho');
$ig_nap = arr::get($_REQUEST , 'ig_nap');

$type = arr::get($_REQUEST , 'tipus');

if ( !empty ($tol_ev ) ) {

    $tol = $tol_ev . "-" . $tol_ho . "-" . $tol_nap;
    $ig = $ig_ev . "-" . $ig_ho . "-" . $ig_nap;
        
    $tolObj = ORM::Factory('Stock')->where('type' , '=' , $type )->where('datum' , '>=' , $tol)->order_by('datum' , 'asc')->find();
    $igObj = ORM::Factory('Stock')->where('type' , '=' , $type )->where('datum' , '<=' , $ig)->order_by('datum' , 'desc')->find();
    
    $day1 = strtotime($tolObj->datum . '12:00:00' );
    $day2 = strtotime($igObj->datum. '12:00:00');
    
    $datediff = $day2 - $day1;
    $diff = floor($datediff/(60*60*24));

    if ( $diff > 0 ) {
    $hozam = 0;
    $hozam_korrigalt = 0;
    
    if ( $diff < 366 ) {
        $hozam = (($igObj->egyjegy / $tolObj->egyjegy)-1)*100/*/($diff)*36500*/;
        $hozam_korrigalt = (($igObj->korrigalt / $tolObj->korrigalt)-1)*100/*/($diff)*36500*/;
    } else {
        if ( $tolObj->egyjegy > 0 ) {
            $ne2ne1 = ($igObj->egyjegy / $tolObj->egyjegy);
			$kitevo = 365 / ($diff);
            $hatvany = pow($ne2ne1 , $kitevo);
            $hozam = ($hatvany -1)*100;
        }

        if ( $tolObj->korrigalt > 0 ) {
            $korrigalt_ne2ne1 = ($igObj->korrigalt / $tolObj->korrigalt);
			$kitevo = 365 / ($diff);
            $korrigalt_hatvany = pow($korrigalt_ne2ne1 , $kitevo);
            $hozam_korrigalt = ($korrigalt_hatvany -1)*100;
        }
    }
     
	 /*
	 echo '<pre>';
     echo 'ne2ne1: ' . $ne2ne1 . '<br />';
     echo 'diff: ' . $diff . '<br />';
     echo 'kitevő: ' . $kitevo . '<br />';
     echo 'hatvány: ' . $hatvany . '<br />';
     echo 'hozam: ' . $hozam . '<br />';
	 echo '</pre>';
	 */
	     
    $hozam = number_format($hozam , 4);
    $hozam_korrigalt = number_format($hozam_korrigalt , 4);
?>
    <table>
        <tbody>
            <tr>
                <td><?php echo __('Értéknap'); ?></td>
                <td><?php echo $tolObj->datum; ?></td>
                <td><?php echo $igObj->datum; ?></td>
            </tr>
            <tr>
                <td><?php echo __('Árfolyam'); ?></td>
                <td><?php echo $tolObj->egyjegy; ?> <?php echo $tolObj->valuta; ?></td>
                <td><?php echo $igObj->egyjegy; ?> <?php echo $igObj->valuta; ?></td>
            </tr>
            <tr>
                <td>
                <?php if ( $diff < 366 ) { ?>
                <?php echo __('Nem évesített hozam'); ?>
                <?php } else { ?>
                <?php echo __('Évesített hozam'); ?>
                <?php } ?>
                </td>
                <td><?php echo ( $type == "0" ) ? nf($hozam , 4 ) : nf($hozam , 2 ); ?>%</td>
                <td></td>
            </tr>

            <?php if ( $type == 48 ) { ?>
            <tr>
                <td>
                <?php if ($diff < 366) { ?>
                <?php echo __('Nem évesített hozamfizetésekkel korrigált hozam'); ?>
                <?php } else { ?>
                <?php echo __('Évesített hozamfizetésekkel korrigált hozam'); ?>
                <?php } ?>
                </td>
                <td><?php echo ($type == "0") ? nf($hozam_korrigalt, 4) : nf($hozam_korrigalt, 2); ?>%</td>
                <td></td>
            </tr>
            <tr>
                <td><?php echo __('Hozamfizetések'); ?></td>
                <td colspan="2">
                    2020.12.22: 117 HUF/db
                </td>
            </tr>
            <?php } ?>
            
        </tbody>
       </table>
       
       <div id="stock">
       
       </div>
       
       <script src="/js/chart.js"></script>
       
       <script type="text/javascript">
        $(function () {
						
			Highcharts.setOptions({
				lang: {
				    <?php if ( $lang == "hu") { ?>
					months: ['Január', 'Február', 'Március', 'Április', 'Május', 'Június',  'Július', 'Augusztus', 'Szeptember', 'Október', 'November', 'December'],
					weekdays: ['Vasárnap', 'Hétfő', 'Kedd', 'Szerda', 'Csütörtök', 'Péntek', 'Szombat']
					<?php  } ?>
				}				
			});

            $.getJSON('/json/<?php echo $type; ?>?tol=<?php echo $tol; ?>&ig=<?php echo $ig; ?>', function (data) {
                // Create the chart
                $('#stock').highcharts('StockChart', {

									
					
                    title : {
                        text : '<?php echo __('Hozamkalkulátor'); ?>'
                    },
					
					
					rangeSelector: {
						enabled: true,
						selected: 4,
						buttons: [{
						  type: 'month',
						  count: 1,
						  text: '<?php echo __('1h'); ?>'
						}, {
						  type: 'month',
						  count: 3,
						  text: '<?php echo __('3h'); ?>'
						}, {
						  type: 'month',
						  count: 6,
						  text: '<?php echo __('6h'); ?>'
						},{
						  type: 'year',
						  count: 1,
						  text: '<?php echo __('1év'); ?>'
						}, {
						  type: 'all',
						  text: '<?php echo __('Mind'); ?>'
						}]
				 	 },

					navigator : {
                        enabled : false
                    },
					
					scrollbar : {
                        enabled : false
                    },	
					
					credits : {
						enabled: false	
					},		
							
					   		
                    
                    series : [
                        {
                            name : '<?php echo __('Egy jegyre jutó eszközérték'); ?>',
                            data : data.data,
                            tooltip: {			
                                valueDecimals: 2,
                                xDateFormat: '%Y-%m-%d',
                                dateTimeLabelFormats: {
                                    week: '%Y-%m-%d'
                                }                  
                            }    				                 
                        },
                        {
                            name : '<?php echo __('Hozamkifizetéssel korrigált eszközérték'); ?>',
                            data : data.data2,
                            tooltip: {			
                                valueDecimals: 2,
                                xDateFormat: '%Y-%m-%d',
                                dateTimeLabelFormats: {
                                    week: '%Y-%m-%d'
                                }                  
                            },
                            dashStyle: 'dot'    				                 
                        }
                
                ]
                });
            });

        });
        </script>
<?php } } ?>